﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIAEMRService.Messages;
using VRM.Integration.Servicebus.Core;
using VA.TMP.OptionSets;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupCancelAppointment
{
    public class GetAppointmentStep:FilterBase<CancelGroupAppointmentStateObject>
    {
        public override void Execute(CancelGroupAppointmentStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {

                state.CrmAppointment = srv.AppointmentSet.FirstOrDefault(a => a.Id == state.AppointmentId);
                if (state.CrmAppointment != null)
                {
                    state.ServiceAppointment = srv.ServiceAppointmentSet.FirstOrDefault(sa => sa.Id == state.CrmAppointment.cvt_serviceactivityid.Id);
                }
                else
                {
                    state.ServiceAppointment = srv.ServiceAppointmentSet.FirstOrDefault(x => x.Id == state.AppointmentId);
                }
            }
            if (state.CrmAppointment == null) throw new Exception("Group Appointment cannot be null");
            if (state.ServiceAppointment == null) throw new Exception("Provider Appointment cannot be null");
        }
    }
}
